/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound;

import eu.ha3.presencefootsteps.PFConfig;
import eu.ha3.presencefootsteps.mixins.IEntity;
import eu.ha3.presencefootsteps.sound.Isolator;
import eu.ha3.presencefootsteps.sound.PFIsolator;
import eu.ha3.presencefootsteps.sound.StepSoundSource;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsJsonParser;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import eu.ha3.presencefootsteps.util.ResourceUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1307;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1480;
import net.minecraft.class_1531;
import net.minecraft.class_1606;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3695;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class SoundEngine
implements IdentifiableResourceReloadListener {
    private static final class_2960 BLOCK_MAP = new class_2960("presencefootsteps", "config/blockmap.json");
    private static final class_2960 GOLEM_MAP = new class_2960("presencefootsteps", "config/golemmap.json");
    private static final class_2960 LOCOMOTION_MAP = new class_2960("presencefootsteps", "config/locomotionmap.json");
    private static final class_2960 PRIMITIVE_MAP = new class_2960("presencefootsteps", "config/primitivemap.json");
    private static final class_2960 ACOUSTICS = new class_2960("presencefootsteps", "config/acoustics.json");
    private static final class_2960 VARIATOR = new class_2960("presencefootsteps", "config/variator.json");
    private static final class_2960 ID = new class_2960("presencefootsteps", "sounds");
    private PFIsolator isolator = new PFIsolator(this);
    private final PFConfig config;

    public SoundEngine(PFConfig config) {
        this.config = config;
    }

    public float getVolumeForSource(class_1309 source) {
        float volume = (float)this.config.getGlobalVolume() / 100.0f;
        if (source instanceof class_1657) {
            volume = PlayerUtil.isClientPlayer((class_1297)source) ? (volume *= (float)this.config.getClientPlayerVolume() / 100.0f) : (volume *= (float)this.config.getOtherPlayerVolume() / 100.0f);
        }
        float runningProgress = ((StepSoundSource)source).getStepGenerator(this).map(generator -> {
            this.config.getRunningVolumeIncrease();
            return Float.valueOf(generator.getMotionTracker().getSpeedScalingRatio(source));
        }).orElse(Float.valueOf(0.0f)).floatValue();
        float runningDecrease = Math.min((float)this.config.getRunningVolumeIncrease() / 100.0f * (1.0f - runningProgress), 0.96f);
        return volume * (1.0f - runningDecrease);
    }

    public Isolator getIsolator() {
        return this.isolator;
    }

    public void reload() {
        if (this.config.getEnabled()) {
            this.reloadEverything(class_310.method_1551().method_1478());
        } else {
            this.shutdown();
        }
    }

    public boolean isRunning(class_310 client) {
        return this.config.getEnabled() && (client.method_1542() || this.config.getEnabledMP());
    }

    private Stream<? extends class_1297> getTargets(class_1297 cameraEntity) {
        return cameraEntity.field_6002.method_8333(null, cameraEntity.method_5829().method_1014(16.0), e -> !(!(e instanceof class_1309) || e instanceof class_1480 || e instanceof class_1307 || e instanceof class_1606 || e instanceof class_1531 || e instanceof class_1690 || e instanceof class_1688 || this.isolator.getGolemMap().contains(e.method_5864()) || e.method_5765() || ((class_1309)e).method_6113() || e instanceof class_1657 && ((class_1657)e).method_7325() || !(e.method_5739(cameraEntity) <= 16.0f) || !this.config.getEnabledGlobal() && !(e instanceof class_1657))).stream();
    }

    public void onFrame(class_310 client, class_1297 cameraEntity) {
        if (!client.method_1493() && this.isRunning(client)) {
            this.getTargets(cameraEntity).forEach(e -> {
                try {
                    ((StepSoundSource)e).getStepGenerator(this).ifPresent(generator -> {
                        generator.setIsolator(this.isolator);
                        if (generator.generateFootsteps((class_1309)e)) {
                            ((IEntity)e).setNextStepDistance(2.1474836E9f);
                        }
                    });
                }
                catch (Throwable t) {
                    class_128 report = class_128.method_560((Throwable)t, (String)"Generating PF sounds for entity");
                    class_129 section = report.method_562("Entity being ticked");
                    if (e == null) {
                        section.method_578("Entity Type", (Object)"null");
                    } else {
                        e.method_5819(section);
                        section.method_578("Entity's Locomotion Type", (Object)this.isolator.getLocomotionMap().lookup((class_1297)e));
                        section.method_578("Entity is Golem", (Object)this.isolator.getGolemMap().contains(e.method_5864()));
                    }
                    this.config.populateCrashReport(report.method_562("PF Configuration"));
                    throw new class_148(report);
                }
            });
            this.isolator.getSoundPlayer().think();
        }
    }

    public boolean onSoundRecieved(@Nullable class_3414 event, class_3419 category) {
        if (event == null || category != class_3419.field_15248 || !this.isRunning(class_310.method_1551())) {
            return false;
        }
        if (event == class_3417.field_14998 || event == class_3417.field_14810 || event == class_3417.field_14794 || event == class_3417.field_14778) {
            return true;
        }
        String[] name = event.method_14833().method_12832().split("\\.");
        return name.length > 0 && "block".contentEquals(name[0]) && "step".contentEquals(name[name.length - 1]);
    }

    public Locomotion getLocomotion(class_1309 entity) {
        if (entity instanceof class_1657) {
            return Locomotion.forPlayer((class_1657)entity, this.config.getLocomotion());
        }
        return this.isolator.getLocomotionMap().lookup((class_1297)entity);
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 sync, class_3300 sender, class_3695 serverProfiler, class_3695 clientProfiler, Executor serverExecutor, Executor clientExecutor) {
        return sync.method_18352(null).thenRunAsync(() -> {
            clientProfiler.method_16065();
            clientProfiler.method_15396("Reloading PF Sounds");
            this.reloadEverything(sender);
            clientProfiler.method_15407();
            clientProfiler.method_16066();
        }, clientExecutor);
    }

    public void reloadEverything(class_3300 manager) {
        this.isolator = new PFIsolator(this);
        ResourceUtils.forEach(BLOCK_MAP, manager, this.isolator.getBlockMap()::load);
        ResourceUtils.forEach(GOLEM_MAP, manager, this.isolator.getGolemMap()::load);
        ResourceUtils.forEach(PRIMITIVE_MAP, manager, this.isolator.getPrimitiveMap()::load);
        ResourceUtils.forEach(LOCOMOTION_MAP, manager, this.isolator.getLocomotionMap()::load);
        ResourceUtils.forEach(ACOUSTICS, manager, new AcousticsJsonParser(this.isolator.getAcoustics())::parse);
        ResourceUtils.forEach(VARIATOR, manager, this.isolator.getVariator()::load);
    }

    public void shutdown() {
        this.isolator = new PFIsolator(this);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            ((IEntity)player).setNextStepDistance(0.0f);
        }
    }
}

